#!/bin/bash

export TWITCH_GOPROXY=${TWITCH_GOPROXY:-"www.production.goproxy.internal.justin.tv"}
export GOPROXY_SSH_FILE="${HOME}/.goproxy.ssh.sock"

function goproxy__enable() {
  if [[ "${1-}" == "help" ]]; then
    echo "Start SSH tunnel to goproxy"
    exit 0
  fi
  if goproxy__status; then
    echo "proxy already enabled"
    return
  fi
  teleport-bastion status
  ssh -fTNMS ${GOPROXY_SSH_FILE} -L 8123:${TWITCH_GOPROXY}:80 dta-twinit-services-proxy-prod.internal.justin.tv
}

function goproxy__status() {
  if [[ "${1-}" == "help" ]]; then
    echo "Check status to goproxy tunnel"
    exit 0
  fi
  ssh -S ${GOPROXY_SSH_FILE} -TO check hostname
}

function goproxy__disable() {
  if [[ "${1-}" == "help" ]]; then
    echo "Disable goproxy tunnel"
    exit 0
  fi
  ssh -S ${GOPROXY_SSH_FILE} -TO exit hostname || true
  rm -f ${GOPROXY_SSH_FILE}
  pgrep -f "ssh.*${GOPROXY_SSH_FILE}" | xargs kill
}

function goproxy_export_env() {
  TORUN=$(goproxy__export || true)
  eval "${TORUN}"
  if echo ${TORUN} | grep "unable to find" > /dev/null ; then
    return 1
  fi
}

function goproxy_docker_run_args() {
  if [[ "${GO_VENDOR_MODE}" == "true" ]]; then
    return
  fi
  # Proxy explicitly set
  if [[ ! -z "${GOPROXY-}" ]]; then
    echo "-e GOPROXY=${GOPROXY/localhost/host.docker.internal}"
    return
  fi
}

function goproxy_docker_build_args() {
  if [[ "${GO_VENDOR_MODE}" == "true" ]]; then
    return
  fi
  # Proxy explicitly set
  if [[ ! -z "${GOPROXY-}" ]]; then
    echo "--build-arg GOPROXY=${GOPROXY/localhost/host.docker.internal}"
    return
  fi
}

function goproxy__export() {
  if [[ "${1-}" == "help" ]]; then
    echo "Export goproxy env variables.  Use with eval:      eval \$(./make.sh goproxy export)"
    exit 0
  fi
  # No proxy in vendor mode
  if [[ "${GO_VENDOR_MODE}" == "true" ]]; then
    >&2 echo "vendor mode proxy disabled"
    return
  fi
  # Proxy explicitly set
  if [[ ! -z "${GOPROXY-}" ]]; then
    >&2 echo "proxy already set: ${GOPROXY}"
    return
  fi
  # Jenkins uses the default proxy
  if in_jenkins; then
    echo "export GOPROXY=http://${TWITCH_GOPROXY}"
    return
  fi
  # Purposely sending proxy via SSH
  if [[ -e "${GOPROXY_SSH_FILE}" ]]; then
    echo "export GOPROXY=http://localhost:8123"
    return
  fi
cat <<zzz23EndOfMessagezzz23
echo "In none vendor mode but unable to find the correct GOPROXY url"
echo "You may need to run in a background shell"
echo
echo "     ./make.sh goproxy enable"
zzz23EndOfMessagezzz23
  return 1
}

function root__goproxy() {
  if [[ "${1-}" == "help" ]]; then
    echo "Run goproxy tunnel commands"
    exit 0
  fi
  process_build goproxy__ $@
}
