# jenkins

This repository contains helper scripts to setup a Jenkins IAM user for your new AWS account.  It lets you run AWS
commands from a jenkins host.  The user has no permissions.  You should run all commands with assumed roles.

A major advantage of this setup is that the commands on the jenkins host can assume the profile name of your account
just like the commands do on your local mac.  This means your jenkins build commands will also work on your mac. 

Steps
1. Verify your aws-cli can communicate with your AWS account with `AWS_PROFILE=twitch-myproduct-prod aws sts get-caller-identity`.
  If your CLI isn't setup currently, you may need to setup isengard for the aws CLI. 
2. Run the script `AWS_PROFILE=twitch-myproduct-prod ./create_jenkins_user.sh`
3. If everything works, there should be a file in your current directory with the same name as your AWS_PROFILE.  `cat ./twitch-myproduct-prod`.
   Note the file will look something like this:
```
[twitch-myproduct-prod]
aws_access_key_id = DEADBEEFDEADBEEF
aws_secret_access_key = ASDFASDF+JLKJL21/1234JKL1

```
4. Upload that file to jenkins credentials https://jenkins.internal.justin.tv/credentials/store/system/domain/discovery/
   by clicking Add Credentials.  Don't put them in the `discovery` domain for jenkins.  Instead, make your own domain.
![alt text](imgs/add_credentials_button.png)
5. Select `Secret file` and put the AWS_PROFILE name as the ID
![alt text](imgs/secret_file_setup.png)
6. Inside your Jenkinsfile, use `withCredentials` before any steps.  This sets the environment variable AWS_CONFIG_FILE
   to the location of your credentials file.  The AWS cli and sdk are smart enough to understand this variable and pull
   credentials out of it.
```
    stage('Production docker push') {
      when {
        anyOf {
          branch 'master';
        }
     }
      steps {
        withCredentials([file(credentialsId: 'twitch-myproduct-prod', variable: 'AWS_SHARED_CREDENTIALS_FILE')]) {
          sh 'AWS_PROFILE=twitch-myproduct-prod aws s3 blah'
        }
      }
    }
```

Or as a global variable for your pipeline
```groovy
pipeline {
  environment {
    AWS_SHARED_CREDENTIALS_FILE = credentials('twitch-myproduct-prod')
  }
  stages {
    stage("Print debug info") {
      steps {
        sh 'AWS_PROFILE=twitch-myproduct-prod aws s3 blah'
      }
    }
  }
}
```