# deprecated

You may want #tps instead.  There are more instructions [on the wiki](https://wiki.twitch.com/display/SYS/How+to+access+LDAP+with+TPS).

# ldap_private_link

Contains cloudformation needed to create a private link to twitch's LDAP service.

# Prerequisites

Make sure your aws-cli works and you have jq installed `brew install jq`.

# How to use
1) Execute `ACCOUNT_NAME=twitch-MYTHING-dev ./create_ldap_link.sh` but add your new account as ACCOUNT_NAME
2) File a JIRA ticket in the SYS queue asking for them to accept your request (or mention it on #systems)
3) Once the request is accepted, execute `ACCOUNT_NAME=twitch-MYTHING-dev ./verify_ldap_link.sh`, but add your new account as AWS_PROFILE
4) Follow the instructions from `verify_ldap_link` to add a DNS name for your LDAP endpoint

# Example output

Here is what it looked like when I ran it

First I ran `./create_ldap_link.sh`

```bash
# ACCOUNT_NAME=twitch-discovery-dev ./create_ldap_link.sh 
aws cloudformation create-stack --disable-rollback --stack-name ldap-private-link --template-body file://ldap_plink.yaml --parameters "file://params/${AWS_PROFILE}.json" --capabilities CAPABILITY_NAMED_IAM
{
    "StackId": "arn:aws:cloudformation:us-east-1:123456789012:stack/myteststack/466df9e0-0dff-08e3-8e2f-5088487c4896"
}

Done!

Please ask in #systems for someone to accept your LDAP private link
```

Then I ran `./verify_ldap_link.sh`

```bash
# ACCOUNT_NAME=twitch-discovery-dev ./verify_ldap_link.sh 
We found the created VPC vpce-040d4be8b3e638f29
Finding DNS name:
Found DNS name:
 vpce-040d4be8b3e638f29-h8d4eayl.vpce-svc-02673a2089b1caf6d.us-west-2.vpce.amazonaws.com

Execute this command on a remote host to verify LDAP connectivity (optional):
  openssl s_client -connect vpce-040d4be8b3e638f29-h8d4eayl.vpce-svc-02673a2089b1caf6d.us-west-2.vpce.amazonaws.com:636 | openssl x509 -noout -text

Now setup a DNS entry.
1. Visit https://dashboard.internal.justin.tv/dns/?entry=ldap-twitch-discovery-dev.internal.justin.tv
2. Click 'CNAME Record' and 'Create'
3. Add an internal CNAME record for vpce-040d4be8b3e638f29-h8d4eayl.vpce-svc-02673a2089b1caf6d.us-west-2.vpce.amazonaws.com
4. Click 'Save all'

Once this is done, you can verify LDAP connectivity by executing on a host:
  ldapsearch -x -H ldaps://ldap-twitch-discovery-dev.internal.justin.tv   -b 'dc=justin,dc=tv' 'uid=ccmolik'
```
