# scratch-ca

A scratch docker image for static builds that Go programs can use.  Includes
only a ca-certs file and timezone file.

## Why you need this

If you don't have certificates installed in your Docker image, Go will be unable to create authenticated HTTPS connections.  Valid cert file locations are visible at https://golang.org/src/crypto/x509/root_linux.go

The timezone file is used by time.LoadLocation

## Why not use a full OS, like ubuntu

If you use a large base image, your built docker file is larger than it has to be.  This assume you build a static binary, which means your Dockerfile is as small as possible.

## How to use

The first line of your Dockerfile should be the scratch image.

```
FROM docker.internal.justin.tv/twitch/scratch-ca:3.1
```

Then build your image as static
```
go build -ldflags "-linkmode external -extldflags -static" .
```

## How to build this image

If you want to update the certificates file, run `./build.sh` with a new value for `IMAGE_VERSION=3.0`.

## How this build works

The builder `./build.sh` will run apt-get inside an ubuntu image to fetch the latest ca-certificates file and copies that to root before running `docker build`.  Alternatives just store this file inside the repository, but with scratch-ca's method it's easy to see where the file comes from and how to update it.
