#!/bin/bash
set -ex

docker run --rm -iv${PWD}:/host-volume ubuntu:trusty sh -s <<EOF
apt-get update
apt-get install -y ca-certificates tzdata
cp -p /etc/ssl/certs/ca-certificates.crt /host-volume
cp -r /usr/share/zoneinfo /host-volume
EOF

TEAM=twitch
IMAGE_NAME=scratch-ca
IMAGE_VERSION=3.2
REPO=docker.internal.justin.tv

FULL_DOCKER_NAME=$REPO/$TEAM/$IMAGE_NAME:$IMAGE_VERSION
docker build -t $FULL_DOCKER_NAME .
docker push $FULL_DOCKER_NAME
