---
layout: "grafana"
page_title: "Grafana: grafana_dashboard"
sidebar_current: "docs-grafana-resource-dashboard"
description: |-
  The grafana_dashboard resource allows a Grafana dashboard to be created.
---

# grafana\_dashboard

The dashboard resource allows a dashboard to be created on a Grafana server.

## Example Usage

```hcl
resource "grafana_dashboard" "metrics" {
  config_json = "${file("grafana-dashboard.json")}"
}
```

Dashboards can be exported from Grafana's web UI in JSON format and provided
via the `config_json` argument.

The exported JSON will include references to Grafana data sources, but the
data source configuration is not exported in this way. In order to fully
manage a dashboard with Terraform, necessary data sources can be created
using the `grafana_data_source` resource. In order to ensure that a data
source is created before a dashboard that refers to it, use the `depends_on`
meta-parameter:

```hcl
    depends_on = ["grafana_data_source.metrics"]
```

## Argument Reference

The following arguments are supported:

* `config_json` - (Required) The JSON configuration for the dashboard.

## Attributes Reference

The resource exports the following attributes:

* `slug` - A URL "slug" for this dashboard, generated by Grafana by removing
  certain characters from the dashboard name given as part of the `config_json`
  argument. This can be used to generate the URL for a dashboard.
