variable "alb_arn" {
  description = "The full ARN of the ALB to monitor"
}

variable "target_group_arn" {
  description = "The full ARN of the target group behind the ALB"
}

variable "alarm_sns_arn" {
  description = "SNS ARN to send monitoring alarms"
}

variable "threshold" {
  description = "The value that triggers the alarm"
}

variable "metric_name" {
  description = "The name of the metric to monitor."
}

variable "evaluation_periods" {
  default     = "5"
  description = "The number of periods over which data is compared to the specified threshold."
}

variable "period" {
  default     = "60"
  description = " period in seconds over which the specified statistic is applied."
}

variable "missing_data_as" {
  description = "How to treat missing data.  You probably want the default"
  default     = "notBreaching"
}

variable "statistic" {
  default = "Sum"
}

data "aws_alb" "input_alb" {
  arn = var.alb_arn
}

data "aws_lb_target_group" "input_target_group" {
  arn = var.target_group_arn
}

locals {
  alb_name          = data.aws_alb.input_alb.name
  alb_arn_suffix    = data.aws_alb.input_alb.arn_suffix
  target_arn_suffix = data.aws_lb_target_group.input_target_group.arn_suffix
}

resource "aws_cloudwatch_metric_alarm" "metric_alarm" {
  alarm_name        = "High ${var.metric_name} for ${local.alb_name}"
  alarm_description = "Alerts on high ${var.metric_name}"
  namespace         = "AWS/ApplicationELB"

  dimensions = {
    LoadBalancer = local.alb_arn_suffix
    TargetGroup  = local.target_arn_suffix
  }

  metric_name         = var.metric_name
  comparison_operator = "GreaterThanOrEqualToThreshold"
  statistic           = var.statistic
  period              = var.period
  evaluation_periods  = var.evaluation_periods
  treat_missing_data  = "notBreaching"
  threshold           = var.threshold
  alarm_actions       = [var.alarm_sns_arn]
  ok_actions          = [var.alarm_sns_arn]
}

