variable "environment" {
  description = "Which env run of the service (staging/production/etc)"
}

variable "service" {
  description = "Name of the service (duplo/visage/etc) behind this ALB"
}

variable "team" {
  description = "The twitch team (feeds/events/etc) that wants this resource"
}

variable "owner" {
  description = "Owner's email (jlindamo@twitch.tv) that wants twitch to pay for this."
}

variable "access_log_bucket" {
  description = "The S3 bucket to put ALB access logs"
}

variable "security_groups" {
  description = "The security groups for the alb.  Usually .account.twitch_subnets_sg"
}

variable "subnets" {
  description = "The subnets for the alb.  Usually .account.private_subnets"
}

variable "vpc_id" {
  description = "The VPC id for the alb target group.  Usually .account.vpc_id"
}
