#!/bin/bash
set -ex

function each_package() {
  if [ "$1" == "." ]; then
    return
  fi
  # These two use a 3rd party plugin that we can't easily get in the docker file
  if [ "$1" == "./pipeline" ]; then
    return
  fi
  if [ "$1" == "./promotion_pipeline" ]; then
    return
  fi
  (
    cd $1
    terraform init
    AWS_DEFAULT_REGION=us-west-2 terraform validate
    terraform fmt -check
  )
}

echo "Verifying directories are formatted"

find . -type f -name '*.tf' | grep -v .terraform | grep -v datapipeline | xargs -n1 dirname | sort | uniq | while read line ; do
  each_package $line
done

