# consulconf simplifies storing a service's configuration data in Consul.
# It creates a key/value pair in Consul where the full key is created from the given team, environment,
# service, and key.
#
# This module requires the root module to configure a consul provider block.
# E.g.
#   provider "consul" {
#     address    = "consul.internal.justin.tv"
#     datacenter = "us-west2"
#   }

variable "team" {
  description = "The twitch team (feeds/events/etc) that wants this resource"
}

variable "service" {
  description = "Name of the service (duplo/visage/etc) storing this configuration"
}

variable "environment" {
  description = "Which env run of the service (staging/production/etc) this configuration belongs to"
}

variable "key" {
  description = "The suffix name of the consul key"
}

variable "value" {
  description = "The value to store in consul"
}

resource "consul_keys" "app" {
  datacenter = "us-west2"

  key {
    path  = "settings/${var.team}/${var.environment}/${var.service}.${var.key}"
    value = var.value
  }
}
