module "core_account" {
  source      = "../core_account"
  xray_role   = var.xray_role
  environment = var.environment
  team        = var.team
}

module "core_region" {
  source                  = "../core_region"
  container_log_retention = var.container_log_retention
  xray_task_arn           = module.core_account.xray_task_role
  region                  = var.region
  environment             = var.environment
  team                    = var.team
  xray_web_arn            = var.xray_role
}

# Output variables

output "container_loggroup" {
  value = module.core_region.container_loggroup
}

output "container_loggroup_region" {
  value = module.core_region.container_loggroup_region
}

output "container_iam_role" {
  value = module.core_account.container_iam_role
}

output "service_iam_role" {
  value = module.core_account.service_iam_role
}

output "xray_task_role" {
  value = module.core_account.xray_task_role
}

output "task_autoscale_iam_role" {
  value = module.core_account.task_autoscale_iam_role
}

output "container_instance_profile_id" {
  value = module.core_account.container_instance_profile_id
}

output "statsite_task_family" {
  value = module.core_region.statsite_task_family
}

output "xray_task_family" {
  value = module.core_region.xray_task_family
}

output "common_cluster_name" {
  value = module.core_region.common_cluster_name
}

output "common_cluster_id" {
  value = module.core_region.common_cluster_id
}

output "build_role" {
  value = module.core_account.build_role
}

output "build_user" {
  value = module.core_account.build_user
}

