variable "region" {
  description = "Region tasks send their logs to"
}

variable "environment" {
  description = "Which env run of the service (staging/production/etc) this belongs to"
}

variable "team" {
  description = "The twitch team (feeds/events/etc) that wants this resource"
}

variable "container_log_retention" {
  description = "Log rotation for AWS container logs"
}

variable "ssm_log_retention" {
  description = "Log rotation for SSM agent logs"
  default     = 7
}

variable "xray_task_arn" {
  description = "ARN that allows xray tasks to send stats"
}

variable "xray_web_arn" {
  description = "The ARN that xray_task_arn should assume and send stats as.  Something like arn:aws:iam::465369119046:role/foundation-xray-role"
}

