variable "team" {
  description = "Team that owns this task (feeds/events/etc)"
}

variable "environment" {
  description = "Environment (integration/staging/etc) of the task"
}

variable "region" {
  description = "Which region the log group is in"
}

variable "loggroup" {
  description = "AWS log group for collectd stdout"
}

variable "sf_api_token" {
  description = "The SignalFx API token for collectd"
}

variable "collectd_interval" {
  default     = 10
  description = "How many seconds to wait between collectd flushes"
}

variable "docker_interval" {
  default     = 300
  description = "How many seconds to wait between docker stat flushes.  Note: Since this is ECS there are a large number of containers and you probably want this to be large."
}

resource "aws_ecs_task_definition" "ecs_signalfx" {
  family                = "${var.team}-${var.environment}-signalfx-collectd"
  container_definitions = data.template_file.ecs_signalfx_def.rendered
  network_mode          = "host"

  volume {
    name      = "host_root"
    host_path = "/"
  }

  volume {
    name      = "docker_sock"
    host_path = "/var/run/docker.sock"
  }
}

data "template_file" "ecs_signalfx_def" {
  template = file("${path.module}/signalfx_collectd.json")

  vars = {
    image             = "docker.internal.justin.tv/twitch/docker-collectd-alpine:1.1"
    region            = var.region
    env               = var.environment
    loggroup          = var.loggroup
    docker_interval   = var.docker_interval
    sf_api_token      = var.sf_api_token
    collectd_interval = var.collectd_interval
  }
}

output "ecs_signalfx_task_family" {
  value = aws_ecs_task_definition.ecs_signalfx.family
}

