variable "region" {
  description = "AWS region (us-west-2) to promote ECS in"
}

variable "team" {
  description = "Team that created this pipeline"
}

variable "service" {
  description = "Which service of the team's to promote"
}

variable "environment" {
  description = "Which env for the service to promote"
}

variable "deploy_aws_role" {
  description = "The ARN of an IAM role that can access these resources."
}

variable "aws_creds" {
  description = "The jenkins credentials that allows promotion pipelines to run AWS commands"
}

variable "profile" {
  description = "The name of the ~/.aws/credentials role (twitch-feed-aws) used to access this resource"
}

variable "cluster_name" {
  description = "The full name of the ECS cluster.  E.g. feeds-common, events-common"
}

variable "service_name" {
  description = "The name of the service.  E.g. feeds-edge, duplo.  This is used with other variables to uniquely name resources."
}

variable "promote_from" {
  default = ""
}

variable auto_promote {
  default = "false"
}

variable "data" {
  type    = "map"
  default = {}
}
