variable "cluster_name" {
  description = "The full name of the ECS cluster."
}

variable "service" {
  description = "The name of the service.  E.g. feeds-edge, duplo.  This is used with other variables to uniquely name resources."
}

variable "environment" {
  description = "Which env for the service"
}

variable "min_size" {
  description = "Least number of tasks to create"
}

variable "max_size" {
  description = "Most number of tasks to create"
}

variable "task_autoscale_iam_role" {
  description = "The IAM role that can do auto scale operations.  You usually want .core.task_autoscale_iam_role"
}

variable "scale_up_cpu" {
  default     = "85"
  description = "How much CPU to scale up at"
}

variable "scale_down_cpu" {
  default     = "25"
  description = "How much CPU to scale down at"
}

