# tgoproxy

Connects your mac to a twitch GHE go module proxy.  tgoproxy stands for [t]witch [go] module [proxy].

## Installing

Add [tgoproxy](./tgoproxy) to your path.  Here is one way to do that.

```
    mkdir -p ~/.bash
    cd ~/.bash
    git clone git@git-aws.internal.justin.tv:twitch/tgoproxy.git
    ln -s ~/.bash/tgoproxy/tgoproxy ~/bin/tgoproxy
    tgoproxy status
```

## Running

```
    tgoproxy enable
    export GOPROXY=$(tgoproxy export)
```

## FAQ

### Who should use this

If you are using [go modules](https://github.com/golang/go/wiki/Modules) and accessing twitch GHE code, this is for you!

### What does it do

It creates a local SSH tunnel to the unofficial
[twitch go module proxy](https://git-aws.internal.justin.tv/discovery/goproxy) using a teleport-remote bastion inside
the proxy VPC.

### Do I need to be on the VPN?

NO!  You just need [teleport-bastion](https://wiki.twitch.com/display/SEC/Teleport+Bastion) enabled.  You *do* need to
be part of the LDAP group `ghe-users`.

### How do I use this from Jenkins?

Set the environment variable `GOPROXY=http://jtv.goproxy.twitch.a2z.com` and it should "just work" from the JTV vpn.

### What if the module proxy is down!

The module proxy has had very good uptime.  However, if the module proxy is unavailable the workaround is to:
1. Connect to JTV vpn (viscosity).
2. Turn off the GOPROXY environment variable
3. Download your code locally
4. Change your build to `-mod=vendor`

```
    unset GOPROXY
    go mod download
    go build -mod=vendor ./...
    git add ./vendor
    git commit -am 'Work around module proxy being down'
```

## Usage

### Enable

Enable the proxy tunnel

```
  tgoproxy enable
```

### Disable

Disable (turn off) the proxy tunnel

```
  tgoproxy disable
```

### Export

Use the proxy tunnel

```
  export GOPROXY=$(tgoproxy export)
  echo $GOPROXY
  go build ./...
```

### Test

Executes a simple command to make sure you can actually contact the proxy.

```
  tgoproxy test
```

### Example terminal usage

```bash
### Here I try running go build and it fails because go modules cannot fetch a dependency
< go build -v ./...
Fetching https://code.justin.tv/hygienic/example?go-get=1
https fetch failed: Get https://code.justin.tv/hygienic/example?go-get=1: dial tcp 52.42.8.112:443: i/o timeout
go: code.justin.tv/hygienic/example@v0.1.0: unrecognized import path "code.justin.tv/hygienic/example" (https fetch: Get https://code.justin.tv/hygienic/example?go-get=1: dial tcp 52.42.8.112:443: i/o timeout)
go: error loading module requirements

### Here I notice the go proxy is not running
> tgoproxy status
Control socket connect(/Users/jlindamo/.tgoproxy.ssh.sock): No such file or directory

### So I enable the go proxy
> tgoproxy enable
Control socket connect(/Users/jlindamo/.tgoproxy.ssh.sock): No such file or directory
The Teleport Bastion is enabled.

### And I notice it is now running
< tgoproxy status
Master running (pid=3419)

### I try building my code again, but it still fails
< go build -v ./...
Fetching https://code.justin.tv/hygienic/example?go-get=1
https fetch failed: Get https://code.justin.tv/hygienic/example?go-get=1: dial tcp 52.42.8.112:443: i/o timeout
go: code.justin.tv/hygienic/example@v0.1.0: unrecognized import path "code.justin.tv/hygienic/example" (https fetch: Get https://code.justin.tv/hygienic/example?go-get=1: dial tcp 52.42.8.112:443: i/o timeout)
go: error loading module requirements

### I notice the GOPROXY environment variable is not set
> echo $GOPROXY

### So I set the environment variable
> tgoproxy export
http://localhost:8123

### But that just prints a string.  I need to export to put that in my shell
< export GOPROXY=$(tgoproxy export)

### Now I notice the variable is set
< echo $GOPROXY
http://localhost:8123

## Verify localy the tgoproxy works
< ./tgoproxy test
"Welcome to The Athens Proxy"
"Welcome to The Athens Proxy"

### Now I build again using the proxy
< go build -v ./...
go: finding code.justin.tv/hygienic/example v0.1.0
Fetching http://localhost:8123/code.justin.tv/hygienic/example/@v/v0.1.0.info
Fetching http://localhost:8123/code.justin.tv/hygienic/example/@v/v0.1.0.mod
go: downloading code.justin.tv/hygienic/example v0.1.0
Fetching http://localhost:8123/code.justin.tv/hygienic/example/@v/v0.1.0.zip
go: extracting code.justin.tv/hygienic/example v0.1.0
code.justin.tv/hygienic/example
code.justin.tv/hygienic/exampledep
```
