## Build Components and Image Recipes

Image Builder enforces uniqueness of Build Components and Image Recipes with `name` and `version`. So the underlying CloudFormation Resource IDs dont work the same as other Resources, where the ID of the CFN Resource is built for you to ensure uniqueness across stacks.

If you update a Build Component, its required to increment the version of that component and the image recipe component.

Where you run into issues:

1. Updating Build component yaml and NOT VERSION, results in ComponentArn error on replacement:

        'AWS::ImageBuilder::Component' with identifier 'ComponentArn' already exists

1. Updating Build component YAML and VERISON, results in ImageRecipeArn:

        'AWS::ImageBuilder::ImageRecipe' with identifier 'ImageRecipeArn' already exists.

WHY: ImageBuilder uses only name and version in its ARNs, thus forcing *new* resources to be created and properly versioned from the get go.
FIX: Increment BOTH versions (stack version and build component version)
A weird side effect (possibly desirable) of this is deletion of old version after creation of new. Meaning the only way to roll back would be thru source code control (ie. reverting commits back to previous version declaration)


## Creating a different stack from this stack fails

This is partially due to the above issue. CFN Tries to create the same build components again.
