# Image Builder CDK

Provides a CDK stack that allows you to configure an EC2 image builder image pipeline to build your EC2 AMIs.

Clone this repository, configure your build components and pipelines, and deploy it to your service account(s)!

## Deploy instructions

### Dependencies

1. NodeJS (recent version)

1. Python3 (>= 3.6)

### Setup

1. Create/Update local virtual environment: `python3 -m venv .env && .env/bin/pip install -r requirements.txt`

### Bootstrap a region

1. `./deploy.sh bootstrap <ACCOUNT_NUM>/<REGION>`

Ex:
```
$ ./deploy.sh bootstrap 360826418937/us-west-2
(node:90804) ExperimentalWarning: The fs.promises API is experimental
 ⏳  Bootstrapping environment 360826418937/us-west-2...
CDKToolkit: creating CloudFormation changeset...
[██████████████████████████████████████████████████████████] (3/3)



 ✅  Environment 360826418937/us-west-2 bootstrapped.
```

1. Make sure your build region is set in `pipeline_config.yaml` to match your bootstrapped region.

1. `./deploy.sh diff`

Ex:
```
$ ./deploy.sh diff
(node:91497) ExperimentalWarning: The fs.promises API is experimental
Stack CDK-image-builder-GenericAMIPipeline-us-west-2
IAM Statement Changes
┌───┬────────────────────────────────────────┬────────┬────────────────────────────────────────┬──────────────────────────────────────────┬───────────┐
│   │ Resource                               │ Effect │ Action                                 │ Principal                                │ Condition │
├───┼────────────────────────────────────────┼────────┼────────────────────────────────────────┼──────────────────────────────────────────┼───────────┤
│ + │ ${CDKImgBuilderEC2InstanceRole.Arn}    │ Allow  │ sts:AssumeRole                         │ Service:ec2.amazonaws.com                │           │
├───┼────────────────────────────────────────┼────────┼────────────────────────────────────────┼──────────────────────────────────────────┼───────────┤
│ + │ ${CDKImgBuilderS3LoggingBucket.Arn}    │ Allow  │ s3:GetObject                           │ AWS:${CDKImgBuilderEC2InstanceRole}      │           │
│   │ ${CDKImgBuilderS3LoggingBucket.Arn}/*  │        │ s3:PutObject                           │                                          │           │
└───┴────────────────────────────────────────┴────────┴────────────────────────────────────────┴──────────────────────────────────────────┴───────────┘
IAM Policy Changes
┌───┬─────────────────────────────────┬─────────────────────────────────────────────────────────────────────────────────────┐
│   │ Resource                        │ Managed Policy ARN                                                                  │
├───┼─────────────────────────────────┼─────────────────────────────────────────────────────────────────────────────────────┤
│ + │ ${CDKImgBuilderEC2InstanceRole} │ arn:${AWS::Partition}:iam::aws:policy/AmazonSSMManagedInstanceCore                  │
│ + │ ${CDKImgBuilderEC2InstanceRole} │ arn:${AWS::Partition}:iam::aws:policy/EC2InstanceProfileForImageBuilder             │
│ + │ ${CDKImgBuilderEC2InstanceRole} │ arn:${AWS::Partition}:iam::aws:policy/AmazonVPCReadOnlyAccess                       │
│ + │ ${CDKImgBuilderEC2InstanceRole} │ arn:${AWS::Partition}:iam::aws:policy/Ec2ImageBuilderCrossAccountDistributionAccess │
└───┴─────────────────────────────────┴─────────────────────────────────────────────────────────────────────────────────────┘
(NOTE: There may be security-related changes not in this list. See https://github.com/aws/aws-cdk/issues/1299)

Parameters
[+] Parameter AssetParameters/f5a2164f4910350e6f2710bfb5ae27e57fe5db5221a0aebef4836dee14daf57d/S3Bucket AssetParametersf5a2164f4910350e6f2710bfb5ae27e57fe5db5221a0aebef4836dee14daf57dS3Bucket98432C92: {"Type":"String","Description":"S3 bucket for asset \"f5a2164f4910350e6f2710bfb5ae27e57fe5db5221a0aebef4836dee14daf57d\""}
[+] Parameter AssetParameters/f5a2164f4910350e6f2710bfb5ae27e57fe5db5221a0aebef4836dee14daf57d/S3VersionKey AssetParametersf5a2164f4910350e6f2710bfb5ae27e57fe5db5221a0aebef4836dee14daf57dS3VersionKey5C49D1B2: {"Type":"String","Description":"S3 key for asset version \"f5a2164f4910350e6f2710bfb5ae27e57fe5db5221a0aebef4836dee14daf57d\""}
[+] Parameter AssetParameters/f5a2164f4910350e6f2710bfb5ae27e57fe5db5221a0aebef4836dee14daf57d/ArtifactHash AssetParametersf5a2164f4910350e6f2710bfb5ae27e57fe5db5221a0aebef4836dee14daf57dArtifactHash51534F84: {"Type":"String","Description":"Artifact hash for asset \"f5a2164f4910350e6f2710bfb5ae27e57fe5db5221a0aebef4836dee14daf57d\""}

Resources
[+] AWS::S3::Bucket CDKImgBuilderS3LoggingBucket CDKImgBuilderS3LoggingBucketAD91551B
[+] AWS::IAM::Role CDKImgBuilderEC2InstanceRole CDKImgBuilderEC2InstanceRole46E653D6
[+] AWS::IAM::Policy CDKImgBuilderEC2S3Policy CDKImgBuilderEC2S3PolicyE0288EF2
[+] AWS::IAM::InstanceProfile CDKImgBuilderInstanceProfile CDKImgBuilderInstanceProfile
[+] AWS::ImageBuilder::Component CDKImgBuilderBuildCmptlogging-0.0.1 CDKImgBuilderBuildCmptlogging001
[+] AWS::ImageBuilder::ImageRecipe CDKImgBuilderRecipeGenericAMIPipeline-1.0.0 CDKImgBuilderRecipeGenericAMIPipeline100
[+] AWS::ImageBuilder::InfrastructureConfiguration CDKImgBuilderInfraCfgGenericAMIPipeline CDKImgBuilderInfraCfgGenericAMIPipeline
[+] AWS::ImageBuilder::DistributionConfiguration CDKImgBuilderDistroCfgGenericAMIPipeline CDKImgBuilderDistroCfgGenericAMIPipeline
[+] AWS::ImageBuilder::ImagePipeline CDKImgBuilderImagePipelineGenericAMIPipeline CDKImgBuilderImagePipelineGenericAMIPipeline
```

1. `./deploy.sh deploy`. This may take a couple minutes.

Ex:
```
$ ./deploy.sh deploy
(node:91582) ExperimentalWarning: The fs.promises API is experimental
This deployment will make potentially sensitive changes according to your current security approval level (--require-approval broadening).
Please confirm you intend to make the following modifications:

IAM Statement Changes
┌───┬────────────────────────────────────────┬────────┬────────────────────────────────────────┬──────────────────────────────────────────┬───────────┐
│   │ Resource                               │ Effect │ Action                                 │ Principal                                │ Condition │
├───┼────────────────────────────────────────┼────────┼────────────────────────────────────────┼──────────────────────────────────────────┼───────────┤
│ + │ ${CDKImgBuilderEC2InstanceRole.Arn}    │ Allow  │ sts:AssumeRole                         │ Service:ec2.amazonaws.com                │           │
├───┼────────────────────────────────────────┼────────┼────────────────────────────────────────┼──────────────────────────────────────────┼───────────┤
│ + │ ${CDKImgBuilderS3LoggingBucket.Arn}    │ Allow  │ s3:GetObject                           │ AWS:${CDKImgBuilderEC2InstanceRole}      │           │
│   │ ${CDKImgBuilderS3LoggingBucket.Arn}/*  │        │ s3:PutObject                           │                                          │           │
└───┴────────────────────────────────────────┴────────┴────────────────────────────────────────┴──────────────────────────────────────────┴───────────┘
IAM Policy Changes
┌───┬─────────────────────────────────┬─────────────────────────────────────────────────────────────────────────────────────┐
│   │ Resource                        │ Managed Policy ARN                                                                  │
├───┼─────────────────────────────────┼─────────────────────────────────────────────────────────────────────────────────────┤
│ + │ ${CDKImgBuilderEC2InstanceRole} │ arn:${AWS::Partition}:iam::aws:policy/AmazonSSMManagedInstanceCore                  │
│ + │ ${CDKImgBuilderEC2InstanceRole} │ arn:${AWS::Partition}:iam::aws:policy/EC2InstanceProfileForImageBuilder             │
│ + │ ${CDKImgBuilderEC2InstanceRole} │ arn:${AWS::Partition}:iam::aws:policy/AmazonVPCReadOnlyAccess                       │
│ + │ ${CDKImgBuilderEC2InstanceRole} │ arn:${AWS::Partition}:iam::aws:policy/Ec2ImageBuilderCrossAccountDistributionAccess │
└───┴─────────────────────────────────┴─────────────────────────────────────────────────────────────────────────────────────┘
(NOTE: There may be security-related changes not in this list. See https://github.com/aws/aws-cdk/issues/1299)

Do you wish to deploy these changes (y/n)? y
CDK-image-builder-GenericAMIPipeline-us-west-2: deploying...
[0%] start: Publishing f5a2164f4910350e6f2710bfb5ae27e57fe5db5221a0aebef4836dee14daf57d:current
[100%] success: Published f5a2164f4910350e6f2710bfb5ae27e57fe5db5221a0aebef4836dee14daf57d:current
CDK-image-builder-GenericAMIPipeline-us-west-2: creating CloudFormation changeset...
[██████████████████████████████████████████████████████████] (11/11)

...

 ✅  CDK-image-builder-GenericAMIPipeline-us-west-2

Stack ARN:
arn:aws:cloudformation:us-west-2:360826418937:stack/CDK-image-builder-GenericAMIPipeline-us-west-2/28a22860-189d-11eb-877c-0a90120142e2
```

### Update

1. Make your changes to the build component(s) you'd like to modify. 

1. Update the version(s) of each component under the `VERSION` file in your build component's subdirectory.

1. Update the `version` key under `pipeline_settings` in `pipeline_config.yaml`.

1. `./deploy.sh [diff|deploy]`

### Rollback

1. Undo your changes (as detailed in [Update](###Update))

1. `./deploy.sh [diff|deploy]`


## Development

### Develop build components locally

You can individually validate the syntax and test building a single component locally with the `awstoe` utility. Below are instructions to get that setup. Note: There are some limitations in testing build components with the docker image in relation to AWS's base AMI (e.g: no systemd in docker, etc.)

1. Build the `awstoe` container (it is safe to ignore gpg warnings as long as the output includes `Good signature from "AWSTOE awstoe@amazon.com"`):
```
docker build -t awstoe .
```

1. Validate syntax of a file. Example:

Single file validate:
```
$ docker run awstoe validate -d ami-imagebuilder-cdk/build_components/logging/logging.yaml
{
    "validationStatus": "success",
    "message": "Document(s) [ami-imagebuilder-cdk/build_components/logging/logging.yaml] is/are valid."
}
```

Multi file validate:
```
$ docker run awstoe validate -d ami-imagebuilder-cdk/build_components/logging/logging.yaml,ami-imagebuilder-cdk/build_components/ssm/ssm.yaml
{
    "validationStatus": "success",
    "message": "Document(s) [ami-imagebuilder-cdk/build_components/logging/logging.yaml ami-imagebuilder-cdk/build_components/ssm/ssm.yaml] is/are valid."
}
```

Multi file validate (with failure):
```
$ docker run awstoe validate -d ami-imagebuilder-cdk/build_components/logging/logging.yaml,ami-imagebuilder-cdk/build_components/ssm/ssm.yaml
{
    "validationStatus": "failed",
    "message": "validate document failed for ami-imagebuilder-cdk/build_components/ssm/ssm.yaml. Error : Invalid schema version. Supported versions include: 1.0."
}
```

1. Run the build of a component. Example:

Simulate the build of a single component. `--trace` makes sure to display console output in stdout.
```
$ docker run awstoe run -d ami-imagebuilder-cdk/build_components/logging/logging.yaml --trace
<console output...>
....
2020-10-21 21:15:18.784 Debug Utils: Skipped uploading logs to S3.
{
    "executionId": "808e014e-13e2-11eb-ae13-0242ac110002",
    "status": "success",
    "failedStepCount": 0,
    "executedStepCount": 7,
    "failureMessage": "",
    "logUrl": "/TOE_2020-10-21_21-15-10_UTC-0_808e014e-13e2-11eb-ae13-0242ac110002"
}
```

### Python virtualenv w/o deploy wrapper

Below are instructions if you do not want to use the deploy wrapper to execute cdk commands:

1. Activate virtualenv:

```
$ source .env/bin/activate
```

1. Once the virtualenv is activated, you can install the required dependencies.

```
$ pip install -r requirements.txt
```

1. Load your isengard creds, and you can now use the deploy wrapper (to run cdk commands).

_Development sidenote_: To add additional dependencies, for example other CDK libraries, just add
them to the `requirements.txt` file and rerun `pip install -r requirements.txt`.


### Appendix: Configure SSM managed instance 

SSM is installed by default in all images. The following is needed to register EC2 instances built from this AMI builder as a managed instance in your account so you can leverage SSM features

1. Include the `AmazonSSMManagedInstanceCore` policy into your instance profile you associate with the EC2 instance you build.

### Appendix: How to SSM Session Manager

#### Console
1. The simplest way to start a session on your EC2 instance is through the AWS console using a privileged role by going to Systems Manager --> Instances and Nodes --> Managed Instances. Select the instance you want to log into, drop down the "Actions" bar and click "Start Session".

![](imgs/console_session.png)

#### Terminal
1. To access an instance with your terminal, first, install the awscli session manager plugin.

```
curl "https://s3.amazonaws.com/session-manager-downloads/plugin/latest/mac/sessionmanager-bundle.zip" -o "sessionmanager-bundle.zip"
unzip sessionmanager-bundle.zip
sudo ./sessionmanager-bundle/install -i /usr/local/sessionmanagerplugin -b /usr/local/bin/session-manager-plugin
```

1. Plug in your isengard creds to your shell session, then log on with the following command:

```
aws ssm start-session --target <EC2-INSTANCE-ID>
```

1. You may view your managed instances's full session history under the Session Manager --> Session History on the AWS console.

### Appendix: Useful CDK commands

 * `cdk ls`          list all stacks in the app
 * `cdk synth`       emits the synthesized CloudFormation template
 * `cdk deploy`      deploy this stack to your default AWS account/region
 * `cdk diff`        compare deployed stack with current state
 * `cdk docs`        open CDK documentation
