class AMI(object):
    """Configuration for ami-imagebuilder-cdk.AmiImageBuildPipelineStack
    """

    def __init__(self, name, version, description=None):
        """
        :param str name: Name of AMI to build
        :param str version: Version of AMI to build, must be updated if changes are made to the Pipeline
        """
        self.name = name
        self.version = version
        self.description = description
        self.parent_image = 'ubuntu-server-18-lts-x86'
        self.parent_image_version = 'x.x.x'   # special for latest
        self.distribute_regions = list()
        self.distribute_accounts = list()
        self.packages = list()
        self.outpost = False

        # EBS Volume config
        self.volume_size = 8
        self.volume_type = 'gp2'
        self.encrypted = False

        self.build_components = list()

    def _get_ebs_spec(self):
        """Returns dict for CfnImageRecipe.EbsInstanceBlockDeviceSpecificationProperty
        """
        return {
            'volume_size': float(self.volume_size),
            'volume_type': self.volume_type,
            'encrypted': self.encrypted,
            'delete_on_termination': True,
        }
