import yaml
import json

from ami_imagebuilder_cdk import UnknownFileType


class BuildComponent(object):
    def __init__(self, name, version, document_file, description=None):
        """a build component"""
        self.name = name
        self.version = version
        self.description = description
        self.data = self._read_document_file(document_file)

        if self.description is None:
            self.description = self._get_description()

    def _read_document_file(self, filename):
        with open(filename) as f:
            return f.read()

    def _get_description(self):
        """reads description from document data to use in component"""
        d = {}
        try:
            d = json.loads(self.data)
        except:
            pass

        try:
            d = yaml.load(self.data, Loader=yaml.FullLoader)
        except:
            pass

        if not d:
            raise UnknownFileType("Unable to parse file with JSON or YAML")

        return d.get('description', None)
