from aws_cdk import (
    core,
    aws_imagebuilder as cdk_ib,
)


class InfrastructureConfigConstruct(core.Construct):
    def __init__(self, scope: core.Construct, id: str, *,
                 instance_profile,
                 instance_types=['t2.micro'],
                 subnet_id=None,
                 security_group_ids=None,
                 logging_bucket=None,
                 description=None,
                 **kwargs) -> None:
        """
        :param instance_profile
        """
        super().__init__(scope, id, **kwargs)

        self._infra_config = cdk_ib.CfnInfrastructureConfiguration(self, '1',
                                                                   name=core.Stack.of(self).stack_name,
                                                                   description=description,
                                                                   instance_types=instance_types,
                                                                   instance_profile_name=instance_profile.instance_profile_name,
                                                                   terminate_instance_on_failure=True,
                                                                   subnet_id=subnet_id,
                                                                   security_group_ids=security_group_ids,
                                                                   logging=self._logging_property(logging_bucket)
                                                                   )
        self._infra_config.add_depends_on(instance_profile)

    def _logging_property(self, bucket=None):
        if bucket is None:
            return None

        return cdk_ib.CfnInfrastructureConfiguration.LoggingProperty(
            s3_logs=cdk_ib.CfnInfrastructureConfiguration.S3LogsProperty(
                s3_bucket_name=bucket.bucket_name,
            )
        )

    @property
    def attr_arn(self):
        return self._infra_config.attr_arn
