import yaml
from aws_cdk import (
    core,
    aws_imagebuilder as cdk_ib,
)

COMPONENT_TEMPLATE = """\
name: InstallPackages
description: Installs more packages
schemaVersion: 1.0

phases:
  - name: build
    steps:
      - name: InstallPackages
        action: ExecuteBash
        inputs:
          commands:
            - apt-get update && apt-get install -y {}
"""


class PackageBuildComponentsConstruct(core.Construct):
    """Auto generated build component to install further list of packages"""

    def __init__(self, scope: core.Construct, id: str, packages, component_version, **kwargs) -> None:
        super().__init__(scope, id, **kwargs)

        name = 'Packages'

        data = COMPONENT_TEMPLATE.format(' '.join(packages))
        self._component = cdk_ib.CfnComponent(self,
                                              "BuildCmpt{}{}".format(name, component_version),
                                              name='{}-{}'.format(core.Stack.of(self).stack_name, name),
                                              description=yaml.load(data, Loader=yaml.FullLoader).get('description'),
                                              platform="Linux",
                                              version=component_version,
                                              data=data,
                                              )

    @property
    def component_arns(self):
        return [self._component.attr_arn]
