#!/usr/bin/env python3
import os
import yaml
from aws_cdk import core
from ami_imagebuilder_cdk.ami_build_pipeline_stack import AmiBuildPipelineStack
from ami_imagebuilder_cdk.ami import AMI

CONFIG_FILE='pipeline_config.yaml'

# reads CONFIG_FILE yaml
def read_config():
    with open(CONFIG_FILE) as f:
        return yaml.load(f, Loader=yaml.FullLoader)


app = core.App()
accountNum = os.environ.get('AWS_ACCOUNT_NUM')

# TODO: what config?
cfg = read_config()
#name = cfg.get('pipeline_settings').get('name')
region = cfg.get('pipeline_settings').get('region')

# setup explicit environment, not implied
env = core.Environment(account=accountNum, region=region)

# create an AMI with a version
ami = AMI('twitch-base-ubuntu-18.04', version='1.0.6')
# ami.distribute_accounts.append('111111111')
# ami.distribute_regions.extend(['us-east-2', 'us-west-2'])

# give AMI to Pipeline Stack
AmiBuildPipelineStack(app, 'TwitchUbuntuBase', ami, env=env)

# create a second AMI
# ami2 = AMI('some-other-test-ami-ubuntu', version='1.0.0')
# ami2.packages = ['git-core']
# AmiBuildPipelineStack(app, 'SomeOtherStackImTesting', ami2, env=env)

# add Tags to the entire app
core.Tags.of(app).add('Description', 'Created with AMI ImageBuilder CDK https://git.xarth.tv/video-coreservices/ami-imagebuilder-cdk')

app.synth()
