#!/usr/bin/env bash

set -eo pipefail

usage() {
    cat <<EOF
Usage: $0 <command> [args ...]
  <command> [args ...]
    In general, these are command and args that are passed to the cdk.
    E.g.
      $0 synth <STACKID>
      gets passed to the cdk as
      cdk synth <STACKID>
EOF
    exit 1
}

while getopts ":" opt; do
  case ${opt} in
    \? )
      usage && exit 1
      ;;
  esac
done

requirements() {
    command -v jq &> /dev/null || ( echo "jq required but missing" && usage )
    command -v npm &> /dev/null || ( echo "cdk required but missing" && usage )
    [ -x "$CDK" ] || {
        cd $script_dir && npm install aws-cdk
    }
}


# Print usage if no arguments or -h is given
[[ "$#" -lt 1 || "$1" == "-h" ]] && usage

script_dir=$(dirname $0)
. $script_dir/.env/bin/activate >/dev/null 2>&1 || {
    python3 -m venv $script_dir/.env
    . $script_dir/.env/bin/activate
    pip install -r $script_dir/requirements.txt
    python3 $script_dir/setup.py install
}

CDK=$script_dir/node_modules/aws-cdk/bin/cdk

requirements

# used by CDK in app.py
export AWS_ACCOUNT_NUM=$(aws sts get-caller-identity | jq '.| .Account|tonumber')

CMD=${@:$OPTIND:1}

shift $((OPTIND-1))

case "$CMD" in
    *)
        exec $CDK "$@"
        ;;
esac
