import setuptools


with open("README.md") as fp:
    long_description = fp.read()


setuptools.setup(
    name="ami_imagebuilder_cdk",
    version="0.0.1",

    description="An empty CDK Python app",
    long_description=long_description,
    long_description_content_type="text/markdown",

    author="author",

    packages=setuptools.find_packages(),
    include_package_data=True,

    install_requires=[
        "pyyaml~=5.4",
        "aws-cdk.core==1.107.0",
        "aws-cdk.aws-iam==1.107.0",
        "aws-cdk.aws-imagebuilder==1.107.0",
        "aws-cdk.aws-s3==1.107.0",
        "aws-cdk.aws-ssm==1.107.0",
    ],

    python_requires=">=3.6",

    classifiers=[
        "Development Status :: 4 - Beta",

        "Intended Audience :: Developers",

        "License :: OSI Approved :: Apache Software License",

        "Programming Language :: JavaScript",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",

        "Topic :: Software Development :: Code Generators",
        "Topic :: Utilities",

        "Typing :: Typed",
    ],
)
