#!/bin/sh

set -ue

get_go_carbon_entries() {
    local availability_zone=$1
    grep go_carbon_${availability_zone} /etc/hosts | \
        cat -n | \
        while read num ip other; do
            echo "    ${ip}:2003=${num}"
        done
}

cat <<CONF >/tmp/carbon-c-relay.conf
cluster go_carbon_a
  fnv1a_ch replication 1
$(get_go_carbon_entries a)
  ;
cluster go_carbon_b
  fnv1a_ch replication 1
$(get_go_carbon_entries b)
  ;

# Rewrite rules to make statsite compatible with statsd naming
rewrite ^stats\.timers\.(.*)\.rate$
  into stats.timers.\1.count_ps
  ;
rewrite ^stats\.timers\.(.*)\.stdev$
  into stats.timers.\1.std
  ;
rewrite ^stats\.timers\.(.*)\.p([0-9]*)$
  into stats.timers.\1.upper_\2
  ;
match ^stats\.counters\.client-event-reporter\.production\.pubsub-js-client\..*\.disconnected\.[0-9]*\.(count|rate)$
  send to blackhole
  ;

match *
  send to
    go_carbon_a
    go_carbon_b
  ;
CONF

/usr/bin/carbon-c-relay -f /tmp/carbon-c-relay.conf
