module "video_org_principal_destination" {
  source = "git::git+ssh://git@git.xarth.tv/terraform-modules/video-organization-principal.git//destination"
}

resource "aws_iam_role" "carbon_c_relay_pull_role" {
  name = "carbon-c-relay-pull-role"
  assume_role_policy = module.video_org_principal_destination.policy.json
}

data "aws_iam_policy_document" "allow_ecr_pull" {
  statement {
    effect = "Allow"
    actions = [
        "ecr:GetDownloadUrlForLayer",
        "ecr:BatchGetImage",
        "ecr:BatchCheckLayerAvailability"
    ]
    resources = [aws_ecr_repository.carbon_c_relay.arn]
  }
}

resource "aws_iam_policy" "role_policy_allow_ecr_pull" {
  name   = "carbon-c-relay-allow-ecr-pull"
  policy = data.aws_iam_policy_document.allow_ecr_pull.json
}

resource "aws_iam_role_policy_attachment" "carbon_c_relay_pull_role_attachement" {
  role       = aws_iam_role.carbon_c_relay_pull_role.id
  policy_arn = aws_iam_policy.role_policy_allow_ecr_pull.arn
}
