# Permit jenkins to upload images to ECR
locals {
  jenkins_role = "carbon-c-relay-jenkins-to-ecr-metrics-role"
}

module "jenkins" {
  source        = "git@git.xarth.tv:video-coreservices/tf-mod-jenkins-role.git?ref=v1.0.1"
  iam_role_name = local.jenkins_role
}

resource "aws_iam_role_policy_attachment" "jenkins_role_ecr_poweruser" {
  role       = local.jenkins_role
  policy_arn = "arn:aws:iam::aws:policy/AmazonEC2ContainerRegistryPowerUser"

  # TODO: fix tf-mod-jenkins-role to provide role name
  depends_on = [module.jenkins]
}
