from cryptography import x509
from cryptography.hazmat import backends
from cryptography.x509.oid import NameOID
from datetime import datetime


class Certificate(object):
    def __init__(self, contents):
        try:
            from cryptography.hazmat.backends.commoncrypto.backend import backend as be_cc
        except ImportError:
            be_cc = None

        try:
            from cryptography.hazmat.backends.openssl.backend import backend as be_ossl
        except ImportError:
            be_ossl = None

        backends._available_backends_list = [
            be for be in (be_cc, be_ossl) if be is not None
        ]

        self.cert = x509.load_pem_x509_certificate(contents, backends.default_backend())

    def days_to_expiry(self):
        t = self.cert.not_valid_after - datetime.now()
        return t.days

    def not_valid_before(self):
        return self.cert.not_valid_before

    def not_valid_after(self):
        return self.cert.not_valid_after

    def issuer(self):
        i = self.cert.issuer.get_attributes_for_oid(NameOID.COMMON_NAME)[0]
        return i.value

    def subject(self):
        s = self.cert.subject.get_attributes_for_oid(NameOID.COMMON_NAME)[0]
        return s.value
