import base64
import boto3
from botocore.config import Config
import logging
import time
from Crypto.Cipher import AES

from certzero.constants import *


class Session(object):
    def __init__(self, role=SANDSTORM_ROLE):
        config = Config(
            retries = {
                'mode': BOTO_RETRY_MODE,
                'max_attempts': BOTO_MAX_ATTEMPTS,
            }
        )

        logging.debug("creating kms client with role {}".format(role))
        c = boto3.client('sts', config=config)
        r = c.assume_role(RoleArn=role, RoleSessionName='kms')
        session = boto3.Session(
            aws_access_key_id=r['Credentials']['AccessKeyId'],
            aws_secret_access_key=r['Credentials']['SecretAccessKey'],
            aws_session_token=r['Credentials']['SessionToken']
            )
        self.kms = session.client('kms', config=config)

    def decrypt(self, key, aad, blob):
        nonce = blob[:12]
        ciphertext = blob[12:-16]
        mac_digest = blob[-16:]

        cipher = AES.new(key, AES.MODE_GCM, nonce)
        cipher.update(aad.encode())
        return cipher.decrypt_and_verify(ciphertext, mac_digest)

    def get_secret(self, item):
        resp = self.kms.decrypt(
            CiphertextBlob=base64.b64decode(item.key),
            EncryptionContext={
                'name': item.name,
                'updated_at': str(int(time.mktime(item.updated_at.timetuple()))),
            })
        s = self.decrypt(resp['Plaintext'], str(resp['KeyId']),
                         base64.b64decode(item.value))

        return s
