job {
    name "vidcs-certzero-build"
    description("build and deploy the video-certzero pypi module")
    using 'TEMPLATE-autobuild'
    scm {
        git {
            remote {
                github 'video-coreservices/certzero', 'ssh', 'git.xarth.tv'
                credentials 'git-aws-read-key'
            }
            clean true
            branches 'origin/*'
        }
    }

    wrappers{
        credentialsBinding {
            string('dtatoolsdeploy', 'dtatoolsdeploy')
            string('dta_tools_deploy', 'dta_tools_deploy')
        }
    }

    steps {
        conditionalSteps {
            condition {
                stringsMatch('$GIT_BRANCH', 'origin/master', true)
            }
            steps {
                shell """
                    sed -i "s/video-certzero-staging/video-certzero/" setup.py
                """
            }
        }

        shell """
            sed -i "s/\\.000/.\${BUILD_NUMBER}/" setup.py
            sed -i "s/\\.000/.\${BUILD_NUMBER}/" certzero/constants.py
        """
        uploadPyPi '.'
    }
}

