from setuptools import setup

setup(
    name='video-certzero-staging',
    version='1.0.000',
    author='GHALI Matthew',
    author_email='ghalim@justin.tv',
    packages=['certzero'],
    scripts=[],
    url='https://git.xarth.tv/video-coreservices/certzero',
    description='tools for monitoring certificate expiration',
    long_description=open('README.md').read(),
    install_requires = [
        'boto3<1.17.0',
        'cryptography<=3.2.1',
        'pycryptodome',
    ],
    entry_points={
        "console_scripts": [
            "sandstorm_scan = certzero.apps:sandstorm_scan",
            "filesystem_scan = certzero.apps:filesystem_scan",
            "generate_report = certzero.apps:generate_report",
        ],
    },
)
