terraform {
  backend "s3" {
  }
}

provider "aws" {
  region = var.region
}

module "variables" {
  source = "./vendor/modules/twitch-video-ops-defaults/current"
  region = var.region
}

resource "aws_iam_role" "vidcs_cert_audit" {
  name                  = "vidcs-cert-audit"
  assume_role_policy    = file("assume_role_policy.json")
  max_session_duration  = 43200
}

resource "aws_iam_policy" "policy" {
  name         = "vidcs_cert_audit_policy"
  description  = "Policy for the vidcs cert audit role"
  policy       = file("vidcs_cert_audit_policy_policy.json")
}

resource "aws_iam_policy_attachment" "attach-policy" {
  name =     "attach-policy"
  roles      = ["${aws_iam_role.vidcs_cert_audit.name}"]
  policy_arn = aws_iam_policy.policy.arn
}
