
# Cloudwatch Alarms CDK automation

This project allows operators to configure and replicate CW alarms and its dependencies according to the bare metal pop to region mapping defined by `default_region`. It also allows alarms to be configured and replicated simply by AWS region, though this is not the primary usecase of this code. 
SNS scaffolding included. Autoscaling not. 

## Configure

Refer to ./alarms/twitch-video-ops-aws/config.yaml for an example.
Refer to ./base-metrics/twitch-video-ops-aws/consul-raft-commitTime.json for an example.
 
### Workflow

1. Make a file called `config.yaml` under **alarms/your-account-alias** and configure the yaml. See `alarms/twitch-video-ops-aws/config.yaml` for a tutorial.
1. (OPTIONAL) If you decide not to configure a single metric (i.e: an alarm with a math expression), form an alarm under **base-metrics/your-account_alias/template-alarm-name.json**
1. Load Isengard/AWS creds for your account into your terminal.
1. `./deploy.sh -a <your-account-alias> list`. This will show a list of stacks your account can generate.
1. `./deploy.sh -a <your-account-alias> diff <StackID>`. This will show you a Cfn representation of the resources that are going to be created. You may use a wildcard string like `my-cool-alarm-*` or just `--all` to deploy every alarm stack you've configured.
1. `./deploy.sh -a <your-account-alias> deploy <StackID>`. This will create the CDK resources. You may use a wildcard string like `my-cool-alarm-*` or just `--all` to deploy every alarm stack you've configured.
1. `./deploy.sh -a <your-account-alias> deploy <StackID> --require-approval=never` is the equivalent of the above if your stacks create IAM resources.

### My cfn template is >= 50kbs

It sucks, I know. The error message will look like this:

```
The template for stack "CWAlarmsCDK-consul-raft-commitTime-eu-west-1" is <some_num_greater_than_50>KiB. Templates larger than 50KiB must be uploaded to S3.
Run the following command in order to setup an S3 bucket in this environment, and then re-deploy:
$ cdk bootstrap aws://<acc_num>/<region>
```

Listen to them and run:

```
./deploy.sh -a twitch-video-ops-aws bootstrap aws://<acc_num>/<region>
```

then re-run step 5 above. 


### Forming an alarm json sounds hard

You can just make a test alarm and use the awscli to get the Metrics array json and copy paste it.
 
 ```
 aws --region <region> cloudwatch describe-alarms --alarm-names=<my-test-alarm-name>
 ```

Enjoy!
