#!/usr/bin/env bash

set -eo pipefail

ACCOUNT=''

usage() {
    cat <<EOF
Usage: $0 <command> [args ...]
  <command> -a <ACCOUNT_NAME> [args ...]
    In general, these are command and args that are passed to the cdk
    E.g.
      $0 -a <ACCOUNT_NAME> synth <STACKID>
      gets passed to the cdk as
      cdk synth <STACKID>
EOF
    exit 1
}

while getopts ":a:" opt; do
  case ${opt} in
    a )
      ACCOUNT=$OPTARG
      ;;
    \? )
      usage && exit 1
      ;;
  esac
done

# cdk code requires this to be set in the environment
export AWS_ACCOUNT_NAME="$ACCOUNT"
# unset https_proxy cuz macOS
export AWS_ACCOUNT_NUM=$(https_proxy='' aws sts get-caller-identity | jq '.| .Account|tonumber')

PROXY_LINE="https_proxy=$https_proxy"

CMD=${@:$OPTIND:1}

shift $((OPTIND-1))

case "$CMD" in
    *)
        # get latest datacenters metadata
        rm -f *.tfstate && terraform get -update && terraform init && terraform apply -auto-approve
        # reproducible deploy env.
        docker build -t cwalarm_cdk .
        docker run --rm -e $PROXY_LINE \
        -e AWS_ACCOUNT_NAME=$AWS_ACCOUNT_NAME \
        -e AWS_ACCOUNT_NUM=$AWS_ACCOUNT_NUM \
        -e AWS_ACCESS_KEY_ID=$AWS_ACCESS_KEY_ID \
        -e AWS_SECRET_ACCESS_KEY=$AWS_SECRET_ACCESS_KEY \
        -e AWS_SESSION_TOKEN=$AWS_SESSION_TOKEN \
        -v "$(pwd)":/cdk-dir \
        --entrypoint="" \
        -t "cwalarm_cdk:latest" \
        /cdk.sh $@
        ;;
esac
