
# Cloudwatch Dashboard Maker

Make it eas(ier) to generate a bunch of dashboards or augment an existing dashboard based off an existing cloudwatch dashboard

## Use cases

### Supported use cases

- Replicating dashboards where the dashboard contents are a collection of metrics gathered from one dimension (POP OR role/machine-class)
  - dashboards that are specific to a pop may be replicated across all POPs through the yaml configuration
  - dashboards that are specific to a role may be replicated across all AWS regions where metrics exist. This is configurable. 


### Unsupported use cases

- Replicating complex, unstructured dashboards. (i.e: a user wishes a dashboard to be replicated across multiple pops and across all AWS regions at the same time)

## Workflow

- build template dashboard
- configure yaml
- `cdk deploy`
- replicated dashboards!

If you want to regenerate the dashboards (say you want some yaml config changes), please run `cdk destroy` and then `cdk deploy`.
The reason it's necessary to destroy before deploying is that the cdk generates deterministic dashboard names and base CDK
functionality (from what I can see) does not allow updating existing cloudwatch dashboards.

## Main Features

* Allow a user to replicate a dashboard they made by a specific dimension (i.e: POP or role)
  - Note: replication can only occur in one dimension. For example, if a user builds a template
          dashboard that is a video-edge dashboard for a specific POP, then that dashboard can only
          be replicated as multiple video-edge dashboards for multiple pops. On the other hand, if a user
          builds a template dashboard that is a global video-edge dashboard of generic system stats and wishes
          to replicate these metrics across different roles, she may take advantage of the multi-region feature
  - This is particularly useful if metrics are published in multiple regions and you wish to build
    a single dashboard that visualizes your metrics in multiple regions.

* Allow a user to create an entrypoint dashboard to refer to all replicated dashboard  
  - **IMPORTANT**: Creates a second dashboard because the CDK cannot update an existing dashboard.

## Some more details

- Uses consul to autodiscover bare metal pops if a user doesn't specify anything
- Does not use consul to autodiscover roles (yet).
- The maximum number of metrics you can include in a single widget to get multi-region functionality to work
  is 100. You can calculate the number of metrics that will be generated in a widget by: <num-regions> * <num-metrics>




## CDK autogenerated README

This is a blank project for Python development with CDK.

The `cdk.json` file tells the CDK Toolkit how to execute your app.

This project is set up like a standard Python project.  The initialization
process also creates a virtualenv within this project, stored under the .env
directory.  To create the virtualenv it assumes that there is a `python3`
(or `python` for Windows) executable in your path with access to the `venv`
package. If for any reason the automatic creation of the virtualenv fails,
you can create the virtualenv manually.

To manually create a virtualenv on MacOS and Linux:

```
$ python3 -m venv .env
```

After the init process completes and the virtualenv is created, you can use the following
step to activate your virtualenv.

```
$ source .env/bin/activate
```

If you are a Windows platform, you would activate the virtualenv like this:

```
% .env\Scripts\activate.bat
```

Once the virtualenv is activated, you can install the required dependencies.

```
$ pip install -r requirements.txt
```

At this point you can now synthesize the CloudFormation template for this code.

```
$ cdk synth
```

To add additional dependencies, for example other CDK libraries, just add
them to your `setup.py` file and rerun the `pip install -r requirements.txt`
command.

# Useful commands

 * `cdk ls`          list all stacks in the app
 * `cdk synth`       emits the synthesized CloudFormation template
 * `cdk deploy`      deploy this stack to your default AWS account/region
 * `cdk diff`        compare deployed stack with current state
 * `cdk docs`        open CDK documentation

Enjoy!
