#!/bin/bash

set -ue

argv=()
datacenters=""
datacenters_list=""

while (( $# )); do
    case "$1" in
        --datacenters)
            datacenters_list="${2}"
            shift 2
            ;;
        --datacenters=*)
            datacenters_list="${1#*=}"
            shift
            ;;
        *)
            argv+=($1)
            shift
            ;;
    esac
done

[ -n "$datacenters_list" ] && datacenters=$(grep -v ^# $datacenters_list)
[ -z "$datacenters" ] && echo "Error: please specify --datacenters=/path/to/datacenter_list" && exit

export ANSIBLE_HOST_KEY_CHECKING=False

for x in $datacenters; do
    echo "*** $x"
    DATACENTER=$x ansible-playbook "${argv[@]}" || {
        echo "Error: ansible-playbook failed for $x"
    }
done
