package main

import (
	"fmt"
	"os"

	"code.justin.tv/video-coreservices/consul-backinator-lambda/common"
)

func main() {
	// get all datacenters
	datacenters, err := common.GetDatacenters()
	if err != nil {
		fmt.Fprintf(os.Stderr, "Error getting datacenters")
		os.Exit(1)
	}

	// run the backup command for each Datacenter
	for _, dc := range datacenters {
		backup := common.NewBackup(dc)

		// args need to be in CLI form
		args := []string{
			fmt.Sprintf("-addr=%s", common.ConsulAddr),
			fmt.Sprintf("-scheme=%s", common.ConsulScheme),
			fmt.Sprintf("-dc=%s", dc),
			fmt.Sprintf("-file=%s.bak", dc),
			// TODO: need to add -key argument for encryption... sandstorm?
		}
		if err := backup.Run(args); err > 0 {
			// TODO: possibly not exit on error for a single DC
			fmt.Fprintf(os.Stderr, "Error executing backup")
			os.Exit(1)
		}
	}
}
