package common

import "github.com/hashicorp/consul/api"

const (
	ConsulAddr   = "api.us-west-2.prod.consul.live-video.a2z.com"
	ConsulScheme = "https"
)

// create a new default consul client with hardcoded defaults
func newClient() (*api.Client, error) {
	config := api.DefaultNonPooledConfig()
	config.Address = ConsulAddr
	config.Scheme = ConsulScheme
	return api.NewClient(config)
}

// Returns all datacenters
func GetDatacenters() ([]string, error) {
	client, err := newClient()
	if err != nil {
		return nil, err
	}

	return client.Catalog().Datacenters()
}
