package common

import (
	"fmt"
	"log"
	"os"

	"github.com/myENA/consul-backinator/command/backup"
)

// creates a new backinator backup.Command with no frills logging and prefix set to datacenter
func NewBackup(datacenter string) *backup.Command {
	return &backup.Command{
		Self: os.Args[0], // use the name of the binary
		Log:  log.New(os.Stderr, fmt.Sprintf("%s ", datacenter), 0),
	}
}
