module "infra" {
  source = "git::git+ssh://git@git.xarth.tv/chat/terraform.git//infrastructure/twitch-chat-aws?ref=5f32caa071b854d14fd0c191093ae7b1dcc95d6a"
}

module "consul_backinator_lambda" {
  source = "../../../modules/consul-backinator-lambda"

  aws_region  = "us-west-2"
  bucket_name = "chat-consul-kv-backup-production"
  environment = "production"
  owner       = "chat"

  consul_addr  = "prod.consul-chat.twitch.a2z.com"
  consul_https = "false"

  subnet_ids      = "${module.infra.private_subnets}"
  security_groups = ["${module.infra.twitch_subnets_security_group}"]
}

terraform {
  backend "s3" {
    region         = "us-west-2"
    bucket         = "twitch-chat-aws"
    key            = "tfstate/chat/consul-backinator-lambda/production"
    dynamodb_table = "terraform_locks"
  }
}
