module "consul_backinator_lambda" {
  source     = "../../../modules/consul-backinator-lambda"

  aws_region      = "us-west-2"
  bucket_name     = "consul-kv-backup-production"
  environment     = "production"
  pagerduty_url   = "https://events.pagerduty.com/integration/fb79deea275748acb67a80c0b88c7a7d/enqueue"

  subnet_ids      = "${module.vidops_defaults.private_subnet_ids}"
  security_groups = ["${module.vidops_defaults.sg_twitch_subnet_id}"]
}

module "vidops_defaults" {
  source = "git::git+ssh://git@git.xarth.tv/vidops/tf-mod-twitch-video-ops-defaults//prod?ref=v1.0.0"
}

terraform {
  backend "s3" {
    region         = "us-west-2"
    bucket         = "twitch-video-ops-aws-tf-state"
    key            = "services/consul-backinator-lambda/us-west-2/terraform.tfstate"
    dynamodb_table = "terraform_locks"
  }
}
