# consul-backinator-lambda Terraform

This module creates a single Lambda with the necessary IAM policies for running a Consul K/V backup on every datacenter available in a consul cluster.
It writes the backup files to a terraform created s3 bucket of your choosing, with versioning enabled.

  * Lambda Function which executes the Golang Consul-backinator-lambda wrapper.
  * CloudWatch Event rule `every-hour` which executes the lambda every hour.
  * CloudWatch Log Group for Lambda logging.
  * CloudWatch Metric Alarm for Lambda errors >1/hour in a 6 hour period.
  * S3 Bucket for lambda to backup to.
  * IAM Role with policies to write logs to the specific LogGroup, and write to the specific S3 Bucket.

## Variables

  * `aws_region` the AWS region to use
  * `subnet_ids` list of subnet IDs to use with the lambda
  * `security_groups` list of security groups to attach to the lambda
  * `owner` the Owner name (used in tagging of certain resources) (default: `video-coreservices`)
  * `environment` the service Environment
  * `lambda_timeout` the maximum execution time (in seconds) for the lambda to complete
  * `consul_addr` the address of a consul endpoint to use for backups (default: `api.us-west-2.prod.consul.live-video.a2z.com`)
  * `consul_https` use HTTPS for the consul endpoint (default: `true`)
  * `bucket_name` name of the S3 bucket to use
