resource "aws_cloudwatch_event_rule" "cloudwatch_event_rule" {
  name                = "every-hour"
  description         = "Fires every hour"
  schedule_expression = "rate(1 hour)"
}

resource "aws_cloudwatch_event_target" "cloudwatch_event_target" {
  rule      = "${aws_cloudwatch_event_rule.cloudwatch_event_rule.name}"
  target_id = "${aws_lambda_function.lambda_function.id}"
  arn       = "${aws_lambda_function.lambda_function.arn}"
}

resource "aws_cloudwatch_log_group" "log_group" {
  name              = "/aws/lambda/${local.function_name}"
  retention_in_days = 14
}

resource "aws_cloudwatch_metric_alarm" "error_alarm" {
  count               = "${var.pagerduty_url == "" ? 0 : 1}"
  alarm_name          = "${local.function_name}-ErrorCount"
  alarm_description   = "Monitors ${local.function_name} for 3 errors within 3 hours"
  alarm_actions       = ["${aws_sns_topic.cloudwatch_alarm_topic.arn}"]
  ok_actions          = ["${aws_sns_topic.cloudwatch_alarm_topic.arn}"]
  comparison_operator = "GreaterThanThreshold"
  threshold           = "0"
  evaluation_periods  = "3"
  period              = "3600" # 1 Hour
  metric_name         = "Errors"
  namespace           = "AWS/Lambda"
  statistic           = "Sum"
  treat_missing_data  = "breaching" # consider missing data as over threshold
  datapoints_to_alarm = "3"

  dimensions = {
    FunctionName = "${local.function_name}"
  }
}
