resource "aws_iam_role" "role" {
  name               = "${local.service_name}-role"
  assume_role_policy = "${data.aws_iam_policy_document.assume_role_policy.json}"
  tags               = "${local.tags}"
}

resource "aws_iam_policy" "policy" {
  name   = "${local.service_name}"
  path   = "/"
  policy = "${data.aws_iam_policy_document.execute.json}"
}

resource "aws_iam_role_policy_attachment" "policy_attachment" {
  role       = "${aws_iam_role.role.name}"
  policy_arn = "${aws_iam_policy.policy.arn}"
}

data "aws_iam_policy_document" "assume_role_policy" {
  statement {
    actions = ["sts:AssumeRole"]

    principals {
      type        = "Service"
      identifiers = ["lambda.amazonaws.com"]
    }
  }
}

data "aws_iam_policy_document" "execute" {
  # For bucket operations
  statement {
    actions = [
      "s3:GetObject",
      "s3:PutObject",
      "s3:CreateBucket",
    ]

    resources = [
      "${aws_s3_bucket.output_bucket.arn}",
      "${aws_s3_bucket.output_bucket.arn}/*",
    ]
  }

  # For all logging to CloudWatch Logs
  statement {
    actions = [
      "logs:CreateLogStream",
      "logs:PutLogEvents",
    ]

    resources = [
      "${aws_cloudwatch_log_group.log_group.arn}",
    ]
  }

  # For all VPC actions
  statement {
    actions = [
      "ec2:CreateNetworkInterface",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DeleteNetworkInterface",
    ]

    resources = [
      "*",
    ]
  }
}
