resource "aws_lambda_function" "lambda_function" {
  filename         = "${data.archive_file.deploy_package.output_path}"
  source_code_hash = "${data.archive_file.deploy_package.output_base64sha256}"
  function_name    = "${local.function_name}"
  role             = "${aws_iam_role.role.arn}"
  handler          = "backup-lambda"
  timeout          = "${var.lambda_timeout}"
  runtime          = "go1.x"
  description      = "Backup Consul K/V Store from All available Datacenters"
  memory_size      = 512

  tags             = "${local.tags}"

  vpc_config       = {
    subnet_ids         = "${var.subnet_ids}"
    security_group_ids = "${var.security_groups}"
  }

  environment {
    variables = {
      bucket_name  = "${aws_s3_bucket.output_bucket.id}"
      consul_addr  = "${var.consul_addr}"
      consul_https = "${var.consul_https}"
    }
  }
}

resource "aws_lambda_permission" "lambda_permission" {
  statement_id  = "AllowExecutionFromCloudWatch"
  action        = "lambda:InvokeFunction"
  function_name = "${local.function_name}"
  principal     = "events.amazonaws.com"
  source_arn    = "${aws_cloudwatch_event_rule.cloudwatch_event_rule.arn}"
}

data "archive_file" "deploy_package" {
  type        = "zip"
  source_file = "${path.root}/../../../../backup-lambda"
  output_path = "${path.root}/backup-lambda.zip"
}
