resource "aws_s3_bucket" "output_bucket" {
  bucket = "${var.bucket_name}"
  acl    = "private"

  versioning {
    enabled = true
  }

  lifecycle_rule {
    id      = "90 day retention for non-current versions"
    enabled = true

    noncurrent_version_expiration {
      days = 90
    }

    expiration {
      expired_object_delete_marker = true
    }

    abort_incomplete_multipart_upload_days = 7
  }

  tags = "${local.tags}"
}
