resource "aws_sns_topic" "cloudwatch_alarm_topic" {
  count = "${var.pagerduty_url == "" ? 0 : 1}"
  name  = "${local.function_name}-alarm-topic"
}


resource "aws_sns_topic_subscription" "cloudwatch_alarm_subscription" {
  count                  = "${var.pagerduty_url == "" ? 0 : 1}"
  protocol               = "https"
  endpoint_auto_confirms = true
  topic_arn              = "${aws_sns_topic.cloudwatch_alarm_topic.arn}"
  endpoint               = "${var.pagerduty_url}"
}
