variable "aws_region" {
  description = "The AWS region to create things in."
  default     = "us-west-2"
}

variable "subnet_ids" {
  description = "List of VPC subnet IDs"
  type        = "list"
}

variable "security_groups" {
  description = "List of security group IDs"
  type        = "list"
}

variable "owner" {
  description = "Name of the owner (team) of this service"
  default     = "video-coreservices"
}

variable "environment" {
  description = "Name of the environment of this service"
}

variable "lambda_timeout" {
  description = "Time limit for Lambda execution in seconds"
  default     = 900
}

variable "consul_addr" {
  description = "Consul endpoint"
  default     = "api.us-west-2.prod.consul.live-video.a2z.com"
}

variable "consul_https" {
  description = "Consul to use HTTPS"
  default     = "true"
}

variable "bucket_name" {
  description = "Name of bucket to backup to"
}

variable "pagerduty_url" {
  description = "The pagerduty integration URL to use for the SNS topic subscription"
  default     = ""
}
