sudo -s

function log() {
    echo "$(hostname) [$(date)]: $*"
}

function logerr() {
    log "$*" >&2
}

if ! pgrep -f '/usr/bin/consul agent'; then
    log "consul was not running"
    [[ -f /tmp/consul-enabled ]] || touch /tmp/consul-disabled
else
    log "Stopping consul"
    touch /tmp/consul-enabled
    systemctl stop consul
fi

log "nuking state"
rm -rf /var/lib/consul/proxy
rm -rf /var/lib/consul/serf

# Validation
pgrep -f /usr/bin/consul &>/dev/null && logerr "CONSUL STILL EXIST"
[[ -d /var/lib/consul/proxy || -d /var/lib/consul/serf ]] && logerr "CONSUL DATA STILL EXIST"

log "Done nuking"
